/*
 * @(#)PaletteColorChooserPreviewPanel.java  
 *
 * Copyright (c) 1996-2010 by the original authors of JHotDraw and all its
 * contributors. All rights reserved.
 *
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with the copyright holders. For details
 * see accompanying license terms.
 */

package org.jhotdraw.gui.plaf.palette.colorchooser;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;

/**
 * PaletteColorChooserPreviewPanel.
 *
 * @author  Werner Randelshofer
 * @version $Id$
 */
public class PaletteColorChooserPreviewPanel extends JPanel implements UIResource {
    private final static Color previewBorderColor = new Color(0x949494);
    private final static Color previewBackgroundColor = new Color(0xffffff);
    /** Creates new form. */
    public PaletteColorChooserPreviewPanel() {
        initComponents();
        //setBorder(new VisualMargin(3,0,3,0));
        setToolTipText("on"); // set dummy text, to switch tooltip on
    }
    
    public void paintComponent(Graphics g) {
        Insets insets = getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = getWidth() - insets.left - insets.right;
        int h = getHeight() - insets.top - insets.bottom;
        g.setColor(previewBackgroundColor);
        g.fillRect(x+1,y+1,w-2,h-2);
        g.setColor(previewBorderColor);
        g.drawRect(x,y,w-1,h-1);
        g.setColor(getForeground());
        g.fillRect(x+2,y+2,w-4,h-4);
    }
    
    public String getToolTipText(MouseEvent evt) {
        Color color = getForeground();
        return (color == null) ? null : color.getRed()+", "+ color.getGreen() + ", " + color.getBlue();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setPreferredSize(new java.awt.Dimension(26, 26));
        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
